/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.mixin.illager;

import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.api.RaiderNameManager;
import java.util.Objects;
import net.minecraft.class_1564;
import net.minecraft.class_1581;
import net.minecraft.class_1604;
import net.minecraft.class_1632;
import net.minecraft.class_1640;
import net.minecraft.class_2487;
import net.minecraft.class_3763;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3763.class})
public abstract class RaiderEntityMixin
implements RaiderNameManager {
    private String firstName = null;
    private String fullName = null;
    private String lastName = null;
    private String playerName = null;
    private String title = this.getDefaultTitle();

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.updateFullName();
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public String getDefaultTitle() {
        class_3763 entity = (class_3763)this;
        if (entity instanceof class_1564) {
            return "Evoker";
        }
        if (entity instanceof class_1581) {
            return "Illusioner";
        }
        if (entity instanceof class_1604) {
            return "Pillager";
        }
        if (entity instanceof class_1632) {
            return "Vindicator";
        }
        if (entity instanceof class_1640) {
            return "Witch";
        }
        return null;
    }

    @Override
    public void setPlayerName(String name) {
        this.playerName = name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setLastName(String lastNames) {
        this.lastName = lastNames;
        this.updateFullName();
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void removeTitle() {
        this.title = null;
        this.updateFullName();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.updateFullName();
    }

    @Override
    public String getFullName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        return this.fullName;
    }

    @Override
    public void updateFullName() {
        StringBuilder builder = new StringBuilder();
        Objects.requireNonNull(this.firstName);
        if (VillagerNames.CONFIG.villagerGeneralConfig.reverseLastNames && VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.lastName).append(" ").append(this.firstName);
        } else if (VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.firstName).append(" ").append(this.lastName);
        } else {
            builder.append(this.firstName);
        }
        if (VillagerNames.CONFIG.villagerGeneralConfig.professionNames && this.title != null && !this.title.equals("None")) {
            builder.append(" the ").append(this.title);
        }
        this.fullName = builder.toString();
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void serializeData(class_2487 tag, CallbackInfo ci) {
        if (this.firstName != null) {
            tag.method_10582("firstName", this.firstName);
        }
        if (this.fullName != null) {
            tag.method_10582("fullName", this.fullName);
        }
        if (this.lastName != null) {
            tag.method_10582("lastName", this.lastName);
        }
        if (this.title != null) {
            tag.method_10582("title", this.title);
        }
        if (this.playerName != null) {
            tag.method_10582("playerName", this.playerName);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void deserializeData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("firstName")) {
            this.firstName = tag.method_10558("firstName");
        }
        if (tag.method_10545("fullName")) {
            this.fullName = tag.method_10558("fullName");
        }
        if (tag.method_10545("lastName")) {
            this.lastName = tag.method_10558("lastName");
        }
        if (tag.method_10545("title")) {
            this.title = tag.method_10558("title");
        }
        if (tag.method_10545("playerName")) {
            this.playerName = tag.method_10558("playerName");
        }
    }
}

